﻿//FileViewerTextWindow
//PanotiSoft 
//Markus Zerhusen
//20.09.2017

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace FileViewer
{
  public partial class FileViewerTextWindow: Form
  {
    #region Contructor

    public FileViewerTextWindow() {
      InitializeComponent();

      this.Icon = Properties.Resources.IconMain;
    }

    #endregion


    #region Private Events: Form

    private void FileViewerTextWindow_Shown(object sender, EventArgs e) {
      this.TextBoxInfo.DeselectAll();
    }

    #endregion


    #region Public Methods

    public void Run(Form Parent, String Title, String Text, String[] TextArray) {
      if(Text != null)
        this.TextBoxInfo.Text = Text;

      if(TextArray != null)
        this.TextBoxInfo.Lines = TextArray;

      this.Text = "FileViewer: " + Title;

      this.ShowDialog(Parent);

      this.TextBoxInfo.Text = String.Empty;
      this.TextBoxInfo.Lines = null;
    }

    #endregion   
  }
}
