﻿//FileViewerProtectedWindow
//PanotiSoft 
//Markus Zerhusen
//20.09.2017

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Media;
using System.Drawing.Imaging;

namespace FileViewer
{
  public partial class FileViewerProtectedWindow: Form
  {
    #region Private Fields

    private FileViewerProtectedData MyData;

    private UInt64 MyMaxSize;

    private Boolean MyRun;

    #endregion


    #region Contructor

    public FileViewerProtectedWindow() {
      InitializeComponent();

      this.ComboBoxColor.SelectedIndex = 0;
    }

    #endregion


    #region Private Events

    private void FileViewerProtectedWindow_Resize(object sender, EventArgs e) {
      if(this.PictureBoxViewer.Image == null) return;

      if(this.PictureBoxViewer.Image.Width >= this.PanelViewer.ClientSize.Width && this.PictureBoxViewer.Image.Height >= this.PanelViewer.ClientSize.Height) {
        if(this.PictureBoxViewer.Left > 0) this.PictureBoxViewer.Left = 0;
        if(this.PictureBoxViewer.Top > 0) this.PictureBoxViewer.Top = 0;

        return;
      }

      if(this.PictureBoxViewer.Image.Width < this.PanelViewer.ClientSize.Width)
        this.PictureBoxViewer.Left = (this.PanelViewer.ClientSize.Width - this.PictureBoxViewer.Image.Width) / 2;
      else
        this.PictureBoxViewer.Left = 0;

      if(this.PictureBoxViewer.Image.Height < this.PanelViewer.ClientSize.Height)
        this.PictureBoxViewer.Top = (this.PanelViewer.ClientSize.Height - this.PictureBoxViewer.Image.Height) / 2;
      else
        this.PictureBoxViewer.Top = 0;
    }

    private void FileViewerProtectedWindow_FormClosing(object sender, FormClosingEventArgs e) {
      this.MyRun = false;
    }


    private void PanelViewer_VisibleChanged(object sender, EventArgs e) {
      this.PanelViewer.AutoScroll = true;
      this.PanelViewer.Refresh();

      this.PictureBoxViewer.Refresh();

      this.FileViewerProtectedWindow_Resize(null, null);
    }


    private void TextBoxPosition_TextChanged(object sender, EventArgs e) {
      UInt64 Position;

      if(UInt64.TryParse(this.TextBoxPosition.Text, out Position)) return;
      
      if(this.TextBoxPosition.Text == String.Empty) return;

      Char[] LetterArray = this.TextBoxPosition.Text.ToCharArray();
      String ValueText = String.Empty;

      foreach(Char Letter in LetterArray)
        if(Char.IsNumber(Letter))
          ValueText += Letter;

      Int32 Index = this.TextBoxPosition.SelectionStart;

      this.TextBoxPosition.Text = ValueText;

      this.TextBoxPosition.SelectionStart = Index - 1;

      SystemSounds.Exclamation.Play();
    }

    private void TextBoxPosition_KeyPress(object sender, KeyPressEventArgs e) {
      if((UInt16) e.KeyChar == 0x0D) {
        e.Handled = true;

        this.ComboBoxColor.Focus();
        return;
      }
    }

    private void TextBoxPosition_Leave(object sender, EventArgs e) {
      UInt64 Position;

      if(UInt64.TryParse(this.TextBoxPosition.Text, out Position)) {
        UInt32 Size;

        if(UInt32.TryParse(this.TextBoxSize.Text, out Size)) {
          Boolean Update = false;

          if(Position >= this.MyMaxSize) {
            Position = this.MyMaxSize - 1;
            Update = true;
          }

          if(Position + Size > this.MyMaxSize) {
            Size = (UInt32) (this.MyMaxSize - Position);
            Update = true;
          }

          if(!Update) {
            if(this.TextBoxPosition.Text == Position.ToString()) return;

            this.TextBoxPosition.Text = Position.ToString();
            return;
          }

          this.TextBoxPosition.Text = Position.ToString();
          this.TextBoxSize.Text = Size.ToString();

          SystemSounds.Exclamation.Play();
          return;
        }
      }

      this.TextBoxPosition.Text = "0";

      SystemSounds.Exclamation.Play();
    }


    private void TextBoxSize_TextChanged(object sender, EventArgs e) {
      UInt32 Size;

      if(UInt32.TryParse(this.TextBoxSize.Text, out Size)) return;
      
      if(this.TextBoxSize.Text == String.Empty) return;

      Char[] LetterArray = this.TextBoxSize.Text.ToCharArray();
      String ValueText = String.Empty;

      foreach(Char Letter in LetterArray)
        if(Char.IsNumber(Letter))
          ValueText += Letter;

      Int32 Index = this.TextBoxSize.SelectionStart;

      this.TextBoxSize.Text = ValueText;

      this.TextBoxSize.SelectionStart = Index - 1;

      SystemSounds.Exclamation.Play();
    }

    private void TextBoxSize_KeyPress(object sender, KeyPressEventArgs e) {
      if((UInt16) e.KeyChar == 0x0D) {
        e.Handled = true;

        this.ComboBoxColor.Focus();
        return;
      }
    }

    private void TextBoxSize_Leave(object sender, EventArgs e) {
      UInt64 Position;

      if(UInt64.TryParse(this.TextBoxPosition.Text, out Position)) {
        UInt32 Size;

        if(UInt32.TryParse(this.TextBoxSize.Text, out Size)) {
          Boolean Update = false;

          if(Size > this.MyMaxSize) {
            Size = (UInt32) this.MyMaxSize;
            Update = true;
          }

          if(Position + Size > this.MyMaxSize) {
            Position = this.MyMaxSize - Size;
            Update = true;
          }

          if(!Update) {
            if(this.TextBoxSize.Text == Size.ToString()) return;

            this.TextBoxSize.Text = Size.ToString();
            return;
          }

          this.TextBoxPosition.Text = Position.ToString();
          this.TextBoxSize.Text = Size.ToString();

          SystemSounds.Exclamation.Play();
          return;
        }
      }

      this.TextBoxSize.Text = "1";

      SystemSounds.Exclamation.Play();
    }


    private void ButtonRun_Click(object sender, EventArgs e) {
      UInt64 Positon;

      if(!UInt64.TryParse(this.TextBoxPosition.Text, out Positon)) return;
      
      UInt32 Size;

      if(!UInt32.TryParse(this.TextBoxSize.Text, out Size)) return;

      Int32 ColorIndex = this.ComboBoxColor.SelectedIndex;


      this.MyRun = true;

      this.ComboBoxColor.Focus();

      this.ButtonRun.Enabled = false;
      this.ButtonRun.Cursor = Cursors.Default;

      this.ProgressBarRun.Value = 0;

      Application.DoEvents();


      Bitmap Image = null;

      try {
        Byte[] ByteArray = this.MyData.CreateMemory(Positon, Size);

        Int32 ImageSize = (Int32) Math.Pow(ByteArray.Length, 0.5);

        this.ProgressBarRun.Maximum = ImageSize;

        Application.DoEvents();

        Image = new Bitmap(ImageSize, ImageSize, PixelFormat.Format24bppRgb);

        Int32 Index = 0;

        switch(ColorIndex) {
          case 0: {
            for(Int32 Y = 0; Y < ImageSize; Y++) {
              for(Int32 X = 0; X < ImageSize; X++)
                Image.SetPixel(X, Y, Color.FromArgb(ByteArray[Index++], 0, 0));

              this.ProgressBarRun.Value = Y;

              Application.DoEvents();

              if(!this.MyRun) return;
            }
            break;
          }
          case 1: {
            for(Int32 Y = 0; Y < ImageSize; Y++) {
              for(Int32 X = 0; X < ImageSize; X++)
                Image.SetPixel(X, Y, Color.FromArgb(0, ByteArray[Index++], 0));

              this.ProgressBarRun.Value = Y;

              Application.DoEvents();

              if(!this.MyRun) return;
            }
            break;
          }
          case 2: {
            for(Int32 Y = 0; Y < ImageSize; Y++) {
              for(Int32 X = 0; X < ImageSize; X++)
                Image.SetPixel(X, Y, Color.FromArgb(0, 0, ByteArray[Index++]));

              this.ProgressBarRun.Value = Y;

              Application.DoEvents();

              if(!this.MyRun) return;
            }
            break;
          }
          case 3: {
            for(Int32 Y = 0; Y < ImageSize; Y++) {
              for(Int32 X = 0; X < ImageSize; X++)
                Image.SetPixel(X, Y, Color.FromArgb(ByteArray[Index], ByteArray[Index], ByteArray[Index++]));

              this.ProgressBarRun.Value = Y;

              Application.DoEvents();

              if(!this.MyRun) return;
            }
            break;
          }
        }

        this.ProgressBarRun.Value = ImageSize;
      } catch(Exception ex) {
        MessageBox.Show(ex.Message, "   Error: Create Image", MessageBoxButtons.OK, MessageBoxIcon.Error);

        Image = null;
      }

      this.PanelViewer.AutoScroll = false;

      this.PictureBoxViewer.Image = Image;
      this.PictureBoxViewer.Location = new Point();
      this.PictureBoxViewer.Size = Image.Size;

      this.PanelViewer_VisibleChanged(null, null);

      this.ButtonRun.Enabled = true;
      this.ButtonRun.Cursor = Cursors.Hand;
    }

    #endregion


    #region Public Methods

    public void Run(Form Parent, FileViewerProtectedData Data) {
      this.ProgressBarRun.Value = 0;
      this.ProgressBarRun.Maximum = 1;

      this.TextBoxPosition.Text = "0";
      this.TextBoxSize.Text = "500000";

      this.PictureBoxViewer.Location = new Point();
      this.PictureBoxViewer.Size = new Size(1, 1);

      this.ButtonRun.Enabled = true;
      this.ButtonRun.Cursor = Cursors.Hand;

      this.MyData = Data;

      if(Data.PageMemorySize == 0)
        this.MyMaxSize = Data.ValueMemorySize;
      else
        this.MyMaxSize = Data.ValueMemorySize * Data.PageMemorySize;

      this.Text = "FileViewer: Protected Memory: " + this.MyMaxSize.ToString("#,#") + " bytes";

      this.ShowDialog(Parent);

      this.PanelViewer.AutoScroll = false;

      this.PictureBoxViewer.Image = null;
      this.PictureBoxViewer.Location = new Point(-1, -1);

      this.MyData = null;
    }

    #endregion   

    
  }
}
