﻿//FileViewerImageWindow
//PanotiSoft 
//Markus Zerhusen
//20.09.2017

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;

namespace FileViewer
{
  public partial class FileViewerImageWindow: Form
  {
    #region Contructor

    public FileViewerImageWindow() {
      InitializeComponent();

      this.Icon = Properties.Resources.IconMain;
    }

    #endregion


    #region Private Events

    private void FileViewerImageWindow_Resize(object sender, EventArgs e) {
      if(this.PictureBoxViewer.Image == null) return;
      
      if(this.PictureBoxViewer.Image.Width >= this.PanelViewer.ClientSize.Width && this.PictureBoxViewer.Image.Height >= this.PanelViewer.ClientSize.Height) {
        if(this.PictureBoxViewer.Left > 0) this.PictureBoxViewer.Left = 0;
        if(this.PictureBoxViewer.Top > 0) this.PictureBoxViewer.Top = 0;

        return;
      }

      if(this.PictureBoxViewer.Image.Width < this.PanelViewer.ClientSize.Width)
        this.PictureBoxViewer.Left = (this.PanelViewer.ClientSize.Width - this.PictureBoxViewer.Image.Width) / 2;
      else
        this.PictureBoxViewer.Left = 0;

      if(this.PictureBoxViewer.Image.Height < this.PanelViewer.ClientSize.Height)
        this.PictureBoxViewer.Top = (this.PanelViewer.ClientSize.Height - this.PictureBoxViewer.Image.Height) / 2;
      else
        this.PictureBoxViewer.Top = 0;
    }

    private void PanelViewer_VisibleChanged(object sender, EventArgs e) {
      this.PanelViewer.AutoScroll = true;
      this.PanelViewer.Refresh();

      this.PictureBoxViewer.Refresh();

      this.FileViewerImageWindow_Resize(null, null);
    }

    #endregion


    #region Public Methods

    public void Run(Form Parent, Image Image) {
      this.PictureBoxViewer.Image = Image;
      this.PictureBoxViewer.Location = new Point();
      this.PictureBoxViewer.Size = Image.Size;

      this.Text = "FileViewer: Image " + Image.Width + "x" + Image.Height;

      this.ShowDialog(Parent);

      this.PanelViewer.AutoScroll = false;

      this.PictureBoxViewer.Image = null;
      this.PictureBoxViewer.Location = new Point(-1, -1);
    }

    #endregion   
  }
}
