﻿//FileViewerColumnWindow
//PanotiSoft 
//Markus Zerhusen
//30.11.2017

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;

namespace FileViewer
{
  public partial class FileViewerColumnWindow: Form
  {
    #region Contructor

    public FileViewerColumnWindow() {
      InitializeComponent();

      this.Icon = Properties.Resources.IconMain;
    }

    #endregion


    #region Private Events

    private void FileViewerColumnWindow_ResizeEnd(object sender, EventArgs e) {
      this.ListView.Columns[this.ListView.Columns.Count - 1].AutoResize(ColumnHeaderAutoResizeStyle.HeaderSize);
    }

    #endregion


    #region Public Methods

    public void Run(Form Parent, String Title, ColumnHeader[] Columns, ListViewItem[] Items, Bitmap[] Bitmaps) {
      this.Text = "FileViewer: " + Title;

      if(Bitmaps != null) {
        this.ListView.SmallImageList = new ImageList();
        this.ListView.SmallImageList.ColorDepth = ColorDepth.Depth24Bit;
        this.ListView.SmallImageList.ImageSize = new Size(75, 16);
        this.ListView.SmallImageList.Images.AddRange(Bitmaps);
      }

      this.ListView.Columns.AddRange(Columns);
      this.ListView.Items.AddRange(Items);

      this.ListView.AutoResizeColumns(ColumnHeaderAutoResizeStyle.HeaderSize);

      this.ShowDialog(Parent);

      this.ListView.Items.Clear();
      this.ListView.Columns.Clear();
      this.ListView.SmallImageList = null;

      GC.Collect();
    }

    #endregion
  }
}
